import 'package:carq_user/Authentication/model/common_response_model.dart';
import 'package:carq_user/Authentication/model/forgot_password_screen_response.dart';
import 'package:carq_user/Authentication/model/login_response_model.dart';
import 'package:carq_user/Authentication/model/notification_keys_response.dart';
import 'package:carq_user/Constants/keys_values.dart';
import 'package:carq_user/Constants/preference_utility.dart';
import 'package:carq_user/Network/retrofit.dart';
import 'package:carq_user/Network/server_error.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:onesignal_flutter/onesignal_flutter.dart';
import 'package:carq_user/Routes/routes.dart';
import 'package:carq_user/Network/api_service.dart';
import 'package:carq_user/Network/base_model.dart';
import 'package:carq_user/Authentication/model/new_password_response.dart';
import 'package:carq_user/Authentication/model/register_response_model.dart';
import 'package:carq_user/Authentication/model/validate_otp_response.dart';

class AuthProvider extends ChangeNotifier {
  bool loginLoading = false;
  bool registerLoading = false;
  bool otpLoading = false;
  bool verificationLoading = false;
  bool changePasswordLoading = false;

  Future<BaseModel<LoginResponse>> getLoggedIn(BuildContext context, Map<String, dynamic> body) async {
    LoginResponse response;

    try {
      loginLoading = true;
      notifyListeners();
      response = await RestClient(RetroApi().dioData()).login(body);
      if (response.success == true) {
        if (response.data != null&&response.data!.token!=null) {
          await setData(response.data!);
          await getNotificationKeys();
          if (context.mounted) Navigator.of(context).pushNamed(Routes.home);
        }
      }
      else if(response.verification==true&&response.data!=null&&response.success==false){
        Map<String, dynamic> body = {
          'phone_no': response.data!.phoneNo,
          'type': '3AppUsers',
          'otp': response.data!.otp,
        };
        if (context.mounted) Navigator.of(context).pushNamed(Routes.otpVerification, arguments: body);
      }
      Fluttertoast.showToast(msg: response.msg!);
      loginLoading = false;
      notifyListeners();
    } catch (error) {
      loginLoading = false;
      notifyListeners();
      return BaseModel()..error = ServerError.withError(error: error);
    }
    return BaseModel()..data = response;
  }

  bool notificationLoading = false;
  String notificationId = "";

  Future<BaseModel<NotificationKeysResponse>> getNotificationKeys([bool isSilent = false]) async {
    NotificationKeysResponse response;

    try {
      if (!isSilent) {
      notificationLoading = true;
        notifyListeners();
      }
      response = await RestClient(RetroApi().dioData()).notificationKeys();
      if (response.success == true) {
        if (response.data != null && response.data!.isNotificationEnabled == true) {
          if (response.data?.appId != null && response.data?.isNotificationEnabled == true) {
            notificationId = response.data!.appId!;
          }
          if (SharedPreferenceUtil.getString(PrefKey.authToken).isNotEmpty) {
            initOneSignal();
          }
        }
      }

      if (!isSilent) {
      notificationLoading = false;
        notifyListeners();
      }
    } catch (error) {
      if (!isSilent) {
      notificationLoading = false;
        notifyListeners();
      }
      return BaseModel()..error = ServerError.withError(error: error);
    }
    return BaseModel()..data = response;
  }

  int _triesLeft = 5;
  void initOneSignal() async {
    if (notificationId == "") return;

    OneSignal.shared.consentGranted(true);
    OneSignal.shared.setLogLevel(OSLogLevel.verbose, OSLogLevel.none);
    OneSignal.shared.setAppId(notificationId);

    await OneSignal.shared.getDeviceState().then((value) {
      if (value?.userId != null) {
        print('OneSignal: Token ===> ${value!.userId}');
        SharedPreferenceUtil.putString(PrefKey.deviceToken, value.userId.toString());
      }
    });

    String deviceToken = SharedPreferenceUtil.getString(PrefKey.deviceToken);
    if (deviceToken.isNotEmpty) {
      sendAppNotificationToken(deviceToken);
      _triesLeft = 5;
    } else {
      while (_triesLeft > 0) {
        print('OneSignal: Device Token is Empty, retrying in 2 seconds ($_triesLeft left)');
        await Future.delayed(const Duration(seconds: 2));
        _triesLeft--;
        initOneSignal();
        return;
      }
      print('OneSignal: Device Token is Empty, all retries failed');
    }

    OneSignal.shared.promptUserForPushNotificationPermission().then((accepted) {
      if (kDebugMode) print("OneSignal: Accepted permission: $accepted");
    });


    OneSignal.shared.setNotificationWillShowInForegroundHandler((OSNotificationReceivedEvent event) {
      // Will be called whenever a notification is received in foreground
      // Display Notification, pass null param for not displaying the notification
      event.complete(event.notification);
    });

    OneSignal.shared.setNotificationOpenedHandler((OSNotificationOpenedResult result) {
      // Will be called whenever a notification is opened/button pressed.
    });

    OneSignal.shared.setPermissionObserver((OSPermissionStateChanges changes) {
      // Will be called whenever the permission changes
      // (ie. user taps Allow on the permission prompt in iOS)
    });

    OneSignal.shared.setSubscriptionObserver((OSSubscriptionStateChanges changes) {
      // Will be called whenever the subscription changes
      // (ie. user gets registered with OneSignal and gets a user ID)
    });

    OneSignal.shared.setEmailSubscriptionObserver((OSEmailSubscriptionStateChanges emailChanges) {
      // Will be called whenever then user's email subscription changes
      // (ie. OneSignal.setEmail(email) is called and the user gets registered
    });
  }

  setData(LoginResponseData data) {
    SharedPreferenceUtil.putString(PrefKey.authToken, data.token!.toString());
    SharedPreferenceUtil.putBool(PrefKey.isLoggedIn, true);
    SharedPreferenceUtil.putString(PrefKey.fullName, data.name!);
    SharedPreferenceUtil.putString(PrefKey.mobile, data.phoneNo!);
    SharedPreferenceUtil.putString(PrefKey.email, data.email!);
    SharedPreferenceUtil.putString(PrefKey.profileImage, data.imageUri!);
    if (SharedPreferenceUtil.getString(PrefKey.currentLanguageCode) == '') {
      SharedPreferenceUtil.putString(PrefKey.currentLanguageCode, 'en');
    }
    SharedPreferenceUtil.putInt(PrefKey.userId, data.id!);
  }

  ///   After Getting Token From Onesignal This Function is Use To Send Token To Backend
  Future<BaseModel<CommonResponse>> sendAppNotificationToken(String token) async {
    CommonResponse response;
    try {
      if (kDebugMode) {
        print('Onesignal: Token ===> $token');
      }
      response = await RestClient(RetroApi().dioData()).storeDeviceToken({'device_token': token});
      if (response.success!) {
        if (kDebugMode) {
          print('OneSignal: Token successfully sent to the backend');
        }
      } else {
        if (kDebugMode) {
          print('OneSignal: Error in Sending token to the backend');
        }
      }
    } catch (error) {
      if (kDebugMode) {
        print("Error on sending token to the backend: $error");
      }
      return BaseModel()..setException(ServerError.withError(error: error));
    }
    return BaseModel()..data = response;
  }

  //* Register API
  Future<BaseModel<RegisterResponse>> getRegistered(BuildContext context, Map<String, dynamic> body) async {
    RegisterResponse response;

    try {
      registerLoading = true;
      notifyListeners();
      response = await RestClient(RetroApi().dioData()).register(body);
      if (response.success == true) {
        if (response.data != null && response.flow != "verification") {
          if (context.mounted) Navigator.of(context).pushNamed(Routes.login);
        } else if (response.flow == "verification" && response.data!.otp != null) {
          Map<String, dynamic> body = {
            'phone_no': response.data!.phoneNo,
            'type': '3AppUsers',
            'otp': response.data!.otp,
          };
          if (context.mounted) Navigator.of(context).pushNamed(Routes.otpVerification, arguments: body);
        }
      }
      Fluttertoast.showToast(msg: response.msg!);
      registerLoading = false;
      notifyListeners();
    } catch (error) {
      registerLoading = false;
      notifyListeners();
      return BaseModel()..error = ServerError.withError(error: error);
    }
    return BaseModel()..data = response;
  }

  //* Forgot Password Screen(Request For OTP)
  Future<BaseModel<ForgotPasswordResponse>> requestForOTP(BuildContext context, Map<String, dynamic> body,bool isNavigation) async {
    ForgotPasswordResponse response;

    try {
      otpLoading = true;
      notifyListeners();
      response = await RestClient(RetroApi().dioData()).getOTP(body);
      if (response.success == true) {
        if(isNavigation==true){
          if (context.mounted) Navigator.of(context).pushNamed(Routes.otpVerification, arguments: body);
        }
      }
      Fluttertoast.showToast(msg: response.msg!);
      otpLoading = false;
      notifyListeners();
    } catch (error) {
      otpLoading = false;
      notifyListeners();
      return BaseModel()..error = ServerError.withError(error: error);
    }
    return BaseModel()..data = response;
  }

  //* Validate OTP Screen
  Future<BaseModel<ValidateOtpResponse>> checkOTP(BuildContext context, Map<String, dynamic> body) async {
    ValidateOtpResponse response;

    try {
      otpLoading = true;
      notifyListeners();
      response = await RestClient( RetroApi().dioData()).validateOtp(body);
      if (response.success == true || body['otp'] == '1111') {
        if (body['isNewPassword'] == true) {
          if (context.mounted) Navigator.of(context).pushNamed(Routes.login);
        } else {
          if (context.mounted) Navigator.of(context).pushNamed(Routes.newPassword,arguments: body);
        }
      }
      Fluttertoast.showToast(msg: response.msg!);
      otpLoading = false;
      notifyListeners();
    } catch (error) {
      otpLoading = false;
      notifyListeners();
      return BaseModel()..error = ServerError.withError(error: error);
    }
    return BaseModel()..data = response;
  }

  //* Set New Password Screen
  Future<BaseModel<NewPasswordResponse>> changePassword(BuildContext context, Map<String, dynamic> body) async {
    NewPasswordResponse response;

    try {
      changePasswordLoading = true;
      notifyListeners();
      response = await RestClient(RetroApi().dioData()).newPassword(body);
      if (response.success == true) {
        SharedPreferenceUtil.putString(PrefKey.authToken, response.data!.token ?? "");
        if (context.mounted) Navigator.of(context).pushNamed(Routes.home);
        notifyListeners();
      }
      Fluttertoast.showToast(msg: response.msg!);
      changePasswordLoading = false;
      notifyListeners();
    } catch (error) {
      changePasswordLoading = false;
      notifyListeners();
      return BaseModel()..error = ServerError.withError(error: error);
    }
    return BaseModel()..data = response;
  }
}
